#pragma once 

// NOTES:
// A full channel(16 pkts) worth of data is
//   598016 bytes.
#define WRITESIZ ((0x1 << 20) << 1) // Size of each get/put in BYTES
#define FBUFSIZE (WRITESIZ + (0x1 << 10)) // Size of our file buffer
#define BUFS_PER_FILE 500 // Number of WRITESIZ packets stored in each file
#define BUF_STORED 64

// Disk Controller class
class DiskController {
public: /* Methods */
	DiskController();
	~DiskController();

	enum IOMode { IDLE, STORING, READING };

public: /* Members */
	int setPath(char *path);
	int beginStoring(void);
	int beginReading(void);
	void stop(void);
	int buffer(const short* buf);
	int get(short* buf);

	static UINT WriteThreadEntry(LPVOID param);
	UINT WriteThread(void);

private: /* Methods */
	int getNextWriteFile(void);
	int getNextReadFile(void);
	void reset(void);
	int put(short* buf);

private: /* Members */
	CWinThread* writeThread;

	FILE *f;
	int fCount;
	IOMode m_mode;
	char m_path[MAX_PATH], m_fileName[MAX_PATH];

	int m_putCount, m_getCount;
	char *m_fileBuffer;

	bool programAlive;
	short **buffers;
	HANDLE myEvents[BUF_STORED];
	volatile int bufStoreIndex;
	volatile int bufWriteIndex;
};